#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

static float Matrix[16];
static float Matrix2[16];
static float Matrix3[16];
static float Matrix4[16];
static float Gouraud[16];
static float Gouraud2[16];

static Obj3d *pCubeFace;
static Obj3d *pCubeFace2;
static Obj3d *pColumn;
static Obj3d *pColumn2;
static Obj3d *pCube;
static Obj3d *pBoule;
static Obj3d *pBoule2;
static DWORD DoubleMot[8] = {0xff0000, 0xff00, 0xff, 0x808000, 0x800080, 0x8080, 0xff, 0x808000};

void LInit_Room()
{
	int Cpt1;

	pCube = GenerateSphere(10, 10, 700, 700, 2048, 512);
	BeIdentityMatrix(Matrix);
	ScaleYMatrix(Matrix, 0.5);
	ApplyMatrix(pCube, Matrix);
	ComputeGouraud(pCube);

	pColumn = GenerateCylinderSpecial(7, 10, 25, 330, 256, 1024);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, 0,0, 450);
	ApplyMatrix(pColumn, Matrix);

	pColumn2 = CopyObj(pColumn);
	for(Cpt1=0;Cpt1<7;Cpt1++)
	{
		BeIdentityMatrix(Matrix);
		RotateYMatrix(Matrix2, Matrix, (Cpt1+1)*8192/8); // (Cpt1+1)*PI2/8
		ApplyMatrix(pColumn2, Matrix2);
		pColumn = CombineObj(pColumn, pColumn2);
	}

	ComputeGouraud(pColumn);
	DeleteObj(pColumn2);

	pBoule = GenerateSphere(10, 10, 50, 50, 256, 256);
	BeIdentityMatrix(Matrix);
/*	TranslateMatrix(Matrix, 0,0, 150);
	ApplyMatrix(pBoule, Matrix);

	pBoule2 = CopyObj(pBoule);
	for(Cpt1=0;Cpt1<=7;Cpt1++)
	{
		BeIdentityMatrix(Matrix);
		RotateYMatrix(Matrix2, Matrix, (Cpt1+1)*8192/8); // (Cpt1+1)*PI2/8
		ApplyMatrix(pBoule2, Matrix2);
		pBoule = CombineObj(pBoule, pBoule2);
	}*/

	PrepareTextureFromArray(g_PicEarth2, 256, 256, &g_TextureEarth2);
	PrepareTextureFromArray(g_PicSolsec, 256, 256, &g_TextureSolsec);

	// Light
}

void QInit_Room()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0);
	grFogTable(g_FogRoom);

	DownloadTexture(&g_TextureEarth2);
	DownloadTexture(&g_TextureSolsec);

	g_demostate.fLight = 0.f;
}

void Effect_Room()
{
	int Img1 = 0;
	int Cpt1;
	DWORD dwFlash;
	float fSize;

	Img1 = g_demostate.TickInEffect/16;

	if (g_demostate.TickInPattern<1024)
	{
		dwFlash = 256*(1000-g_demostate.TickInPattern)/1024;
		dwFlash = CLIP_DW(dwFlash);
		dwFlash = dwFlash|(dwFlash<<8)|(dwFlash<<16);
		grFogColorValue(dwFlash);
	}
	else
		dwFlash = 0;

	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2); // 1/43
	TranslateMatrix(Matrix2, 0, 0, 550);
	RotateZMatrix(Matrix, Matrix2, cos(Img1/43.f)*650); // cos(Img1/43.f)/2

	/*BeIdentityMatrix(Matrix2);
	RotateYMatrix(Matrix3, Matrix2, -g_demostate.TickInEffect*2); // -1/43
	TranslateMatrix(Matrix3, 0, 0, 150);
	RotateZMatrix(Matrix2, Matrix3, cos(Img1/43.f)*650); // cos(Img1/43.f)/2

	TranslateMatrix(Matrix2, 0, 0, 225);*/
	//ScaleMatrix(Matrix, 1.f, 1.f, CosTable[(g_demostate.TickInEffect*4)&8191]+1.5f);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grConstantColorValue(dwFlash);
	DrawWithMatrix(pCube, Matrix, false, Gouraud2, 0);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	SelectTexture(g_TextureEarth2);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	BeIdentityMatrix(Matrix2);
	//fSize = CosTable[(g_demostate.TickInEffect*8192*16/5000)&8191]*0.4f+1.f;
	fSize = CosTable[(g_demostate.TickInEffect*8192*16/5000)&8191]*0.7f+1.3f;
	ScaleMatrix(Matrix2, fSize, fSize, fSize);
	TranslateMatrix(Matrix2, 0, 0, 150.f);
	// new things here
	for(Cpt1=0;Cpt1<8;Cpt1++)
	{
		RotateYMatrix(Matrix3, Matrix2, 8192/8);
		CopyMatrix(Matrix2, Matrix3);
		MulMatrix(Matrix4, Matrix, Matrix3);
		grConstantColorValue(DoubleMot[Cpt1]);
		DrawWithMatrix(pBoule, Matrix4, 0, 0, 0);
	}

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TextureSolsec);
	grConstantColorValue(dwFlash);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grDepthBufferFunction(GR_CMP_LESS);

	DrawWithMatrix(pColumn, Matrix, false, Gouraud2, 0);
}

void ByeBye_Room()
{
	FreeTexture(&g_TextureEarth2);
	FreeTexture(&g_TextureSolsec);

	g_demostate.fLight = 255.f;
}